 ; Ŀ
 ;   Upright: find text entities in a rotated drawing which are not at     
 ;   an acceptable angle and rotate them so that they are.                 
 ;   Copyright 1993 by Rocket Software Ltd.                                
 ;   Not a program for quadrupeds.                                         
 ; 

 ; Ŀ
 ;   Consider allowing to check only blocks with either attributes or      
 ;   encapsulated text.  Also make text rejustification an option          
 ;   - uprt has the rotate around a centrepoint subroutine.                
 ;   Maybe a dialog box - otherwise there are too many options:            
 ;   Text/Attdefs/blocks with text/blocks with attributes/all blocks       
 ;   rejustify text/zoom in on each one/mark each one before committing    
 ; 

 ; Ŀ
 ;   Root - rotate a text entity 180 degrees around its middle.            
 ;   Takes one argument, an entity name.                                   
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN ROOT (enam / aa bb rota cc bheigt bwidth llangg lldist ll ul ur lr pa)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assumining that the  
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (if (setq bb (textbox aa))
      (progn
          (setq rota (cdr (assoc 50 aa)))
          (setq cc (car bb))                    ; ll offset from 10 of text
          (setq dd (cadr bb))                   ; ur offset from 10 of text
          (setq bheigt (- (cadr dd) (cadr cc)))
          (setq bwidth (- (car dd) (car cc)))
          (setq llangg (angle (list 0 0) cc))
          (setq lldist (distance (list 0 0) cc))
          (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
          (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
          (setq lr (polar ll rota bwidth))
          (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   It appears that we now have the real upper left, upper right, etc.    
 ;   points of the text.  This could probably be simplified but since      
 ;   the code is already written...                                        
 ;   Now need the centre point of the text about which to rotate it.       
 ; 
          (setq pa (polar ll (angle ll ur) (/ (distance ll ur) 2.0)))
          (command "rotate" enam "" pa "180")))
 (princ))
 ; Ŀ
 ;   Root end.                                                             
 ; 

 ; Ŀ
 ;   Upp: the subroutine that does the actual work on each entity.         
 ; 
 (DEFUN UPP (aname / aa ten jsave new10 rota)
  (setq aa (entget aname))                          ; get entity data
  (setq ten (cdr (assoc 10 aa)))                    ; starting 10 pos
  (setq jsave (cdr (assoc 72 aa)))                  ; save justification
 ; Ŀ
 ;   Convert to middle justified text.                                     
 ; 
  (entmod (subst (cons 72 4) (assoc 72 aa) aa))     ; change to middle
  (setq new10 (cdr (assoc 10 (entget aname))))      ; new ten pos
  (command "move" aname "" new10 ten)               ; move to original loc.
 ; Ŀ
 ;   Get a fresh copy of the entity data.                                  
 ; 
  (setq aa (entget aname))
 ; Ŀ
 ;   Rotate 180 degrees.                                                   
 ; 
   (setq rota (+ pi (cdr (assoc 50 aa))))
   (entmod (subst (cons 50 rota) (assoc 50 aa) aa))
 ; Ŀ
 ;   Again, get a copy of the entity data.                                 
 ; 
  (setq aa (entget aname))
 ; Ŀ
 ;   Decide what the final justification should be.                        
 ; 
   (cond ((= jsave 2) (setq jsave 0))                ; right becomes left
         ((= jsave 0) (setq jsave 2))                ; left becomes right
         (T))                                        ; anything else is ok
 ; Ŀ
 ;   Reconvert and reposition.                                             
 ; 
  (setq ten (cdr (assoc 10 aa)))                     ; current 10 pos
  (entmod (subst (cons 72 jsave) (assoc 72 aa) aa))  ; change to new just.
  (setq new10 (cdr (assoc 10 (entget aname))))       ; new ten pos
  (command "move" aname "" new10 ten))               ; move to original loc.
 ; Ŀ
 ;   Upp end.                                                              
 ; 

 ; Ŀ
 ;   Upright: the main program.  Get an ss of all text, find any which     
 ;   are at the wrong angle, call Upp to rotate them.                      
 ; 
 (DEFUN C:UPRIGHT (/ ss num nuf rad len so txa ang1 pa just)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Ask what to check, get some.  Maybe all.                              
 ; 
  (initget "Text Inserts Both")
  (setq which (getkword "Check Text/Inserts/<Both>: "))
  (cond ((= which "Text")
         (write-line "Select text to check or <Return> for all: ")
         (if (null (setq ss (ssget '((0 . "TEXT")))))
             (setq ss (ssget "X" '((0 . "TEXT"))))))
        ((= which "Inserts")
         (write-line "Select blocks to check or <Return> for all: ")
         (if (null (setq ss (ssget '((0 . "INSERT")))))
             (setq ss (ssget "X" '((0 . "INSERT"))))))
        ((or (= which "Both") (null which))
         (write-line "Select text and blocks or <Return> for all: ")
         (if (null (setq ss (ssget '((-4 . "<or") (0 . "text")
                                                (0 . "insert") (-4 . "or>")))))
             (setq ss (ssget "X" '((-4 . "<or") (0 . "text")
                                              (0 . "insert") (-4 . "or>")))))))
 ; Ŀ
 ;   If are changeing text, see if should rejustify or just rotate.        
 ; 
  (if (or (member which '("Text" "Both")) (null which))
      (progn
           (initget "Rejustify reJustify Yes No")
           (setq just (getkword "Rejustify text: Yes/<No>: "))
           (setq just (if (or (null just) (= just "No")) nil T))))
 ; Ŀ
 ;   Now process the selection set.                                        
 ; 
  (setq num 0)
  (setq nuf 0)
  (setq rad (/ (- (car (getvar "extmax")) (car (getvar "extmin"))) 25))
  (if ss (setq len (strcat "/" (itoa (sslength ss)))))
  (while (and ss (setq enam (ssname ss num)))
         (setq txa (entget enam))
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (setq ang1 (cdr (assoc 50 txa)))
 ; Ŀ
 ;   See if the current entity is upside down - if the angle is between    
 ;   90 and 270 degrees.                                                   
 ; 
         (if (and (> ang1 (/ pi 2)) (<= ang1 (* pi 1.5)))
             (progn
 ; Ŀ
 ;   Draw marker X (largely for the sake of tradition).                    
 ; 
                  (setq pa (cdr (assoc 10 txa)))
                  (grdraw (polar pa (/ pi 4) rad)
                          (polar pa (* 1.25 pi) rad) 7)
                  (grdraw (polar pa (* pi 0.75) rad)
                          (polar pa (* pi 1.75) rad) 7)
 ; Ŀ
 ;   Call Upp to add 180 degrees (pi radians) to angg.                     
 ; 
                  (if (= (cdr (assoc 0 txa)) "TEXT")
                      (if just (upp enam) (root enam))          ; rotate
                      (command ".rotate" enam "" pa 180))
                  (setq nuf (1+ nuf)))))
  (write-line (strcat "Entities rotated: " (itoa nuf)))
  (command "undo" "end")
 (princ))